/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.planning.ActivityChange;
import cz.insophy.inplan.planning.algorithms.Direction;
import cz.insophy.inplan.planning.mokos.AbstractPositioner;
import cz.insophy.inplan.planning.mokos.PositioningResult;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Bom;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.util.Comparators;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DefaultPositioner
extends AbstractPositioner {
    private Cache<CacheKey, PositioningResult> cache;
    private boolean useCache = false;

    public DefaultPositioner() {
        this.initCache(true);
    }

    private void initCache(boolean collectStats) {
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder().concurrencyLevel(1);
        builder.maximumSize(this.useCache ? 10000L : 0L);
        if (collectStats) {
            builder.recordStats();
        }
        this.cache = builder.build();
    }

    @Override
    public PositioningResult position(GeneralizedActionRequest gar, Action action, Plan plan, Workplace wp, long time, long timeBound, boolean useTools) {
        PositioningResult cachedRes;
        Preconditions.checkNotNull(gar);
        Preconditions.checkNotNull(wp);
        Preconditions.checkArgument(!wp.isCumulative(), "This positioner doesn't handle cumulative workplaces.");
        CacheKey key = new CacheKey(wp, time, gar);
        if (this.useCache && (cachedRes = this.cache.getIfPresent(key)) != null) {
            return cachedRes;
        }
        PositioningResult res = super.position(gar, action, plan, wp, time, timeBound, useTools);
        if (this.useCache) {
            this.cache.put(key, res);
        }
        return res;
    }

    @Override
    protected AbstractPositioner.ActSpaceCollector getActionActCollector(GeneralizedActionRequest gar, Action action, WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, StoreSchedule ss, Bom bom, long time, boolean useTools) {
        return new AaSpaceCollector(gar, action, wps, removedRebs, ss, bom, time, useTools);
    }

    @Override
    protected RebuildType getRebuildTypeOf(WorkplaceActivity wa, Workplace wp) {
        if (wa instanceof RebuildActivity) {
            return ((RebuildActivity)wa).getToType();
        }
        if (wa instanceof ActionActivity) {
            ActionActivity aa = (ActionActivity)wa;
            Action action = aa.getAction();
            String rtName = action.getRebuildType();
            return wp.getRebuildType(rtName);
        }
        return null;
    }

    @Override
    protected AbstractPositioner.BubbleSeeker getFreeSpaceSeeker(WorkplaceSchedule wps, StoreSchedule ss, Bom bom, long time, Action act, boolean useTools) {
        return new AbstractPositioner.BubbleSeeker(wps, ss, bom, time, useTools);
    }

    public void setUseCache(boolean useCache) {
        if (this.useCache != useCache) {
            this.useCache = useCache;
            this.initCache(true);
        }
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    private static class CacheKey {
        public final Workplace workplace;
        public final long time;
        public final GeneralizedActionRequest gar;

        public CacheKey(Workplace workplace, long time, GeneralizedActionRequest gar) {
            this.workplace = workplace;
            this.time = time;
            this.gar = gar;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.gar == null ? 0 : this.gar.hashCode());
            result = 31 * result + (int)(this.time ^ this.time >>> 32);
            result = 31 * result + (this.workplace == null ? 0 : this.workplace.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.gar == null ? other.gar != null : !this.gar.equals(other.gar)) {
                return false;
            }
            if (this.time != other.time) {
                return false;
            }
            return !(this.workplace == null ? other.workplace != null : !this.workplace.equals(other.workplace));
        }
    }

    protected static class AaSpaceCollector
    extends AbstractPositioner.ActSpaceCollector {
        private Workplace wp;
        private double collectedQty;

        public AaSpaceCollector(GeneralizedActionRequest gar, Action action, WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, StoreSchedule ss, Bom bom, long time, boolean useTools) {
            super(gar, action, wps, removedRebs, ss, bom, time, Direction.FORWARD, useTools);
            this.wp = wps.getWorkplace();
            this.collectedQty = 0.0;
        }

        @Override
        public boolean isCollectingComplete() {
            GeneralizedActionRequest gar = this.getGar();
            return Comparators.compare(this.collectedQty, gar.getAmount(), 1.0E-7) >= 0;
        }

        @Override
        protected List<ActivityChange> process(WorkplaceActivity wa) {
            List<Object> aChs;
            GeneralizedActionRequest gar = this.getGar();
            Action action = this.getAction();
            long start = wa.getStart();
            if (wa instanceof Bubble) {
                long bubRemaining;
                long granTime;
                double qty;
                long end;
                double bubbleQty;
                double remainingQty = gar.getAmount() - this.collectedQty;
                if (Comparators.compare(remainingQty, bubbleQty = action.canBeMade(wa.getDuration()), 1.0E-7) <= 0) {
                    end = start + action.timeToMake(remainingQty);
                    this.collectedQty = gar.getAmount();
                    qty = remainingQty;
                } else {
                    end = wa.getEnd();
                    if (Comparators.compare(bubbleQty, 0.0, 1.0E-7) > 0) {
                        this.collectedQty += bubbleQty;
                        qty = bubbleQty;
                    } else {
                        qty = 0.0;
                    }
                }
                if (!((Bubble)wa).isLast() && (granTime = action.timeToMake(action.getGranularity())) > (bubRemaining = wa.getEnd() - end)) {
                    end = wa.getEnd();
                }
                aChs = Comparators.compare(qty, 0.0, 1.0E-7) > 0 ? Lists.newArrayList(new ActivityChange(new ActionActivity(start, end, this.wp, action, qty), ActivityChange.ChangeType.ADDED)) : Collections.emptyList();
                this.updateActsInterval(start, end);
            } else if (wa instanceof OfflineActivity && gar.getAction().getDivisibility() == Action.Divisibility.DIVISIBLE && !((OfflineActivity)wa).isDividing()) {
                aChs = null;
            } else {
                this.failAt(start);
                aChs = null;
            }
            return aChs;
        }
    }
}

